# Ecosystem Starter Kit

Everything you need to build a chartered ecosystem in the Coevolution Society.

## Quick Start

1. Fill in `ecosystem-blueprint.md` with your ecosystem's identity and governance
2. Create ACRS identity files for your first agent (see `acrs/` folder)
3. Configure and deploy your agent (see `agent/` folder)
4. Set up Discord communication (see `gateway/` folder)
5. Install telemetry client: `pip install aicoevolution`
6. Register at https://www.aicoevolution.com/ecosystems/register
7. Submit for charter audit when all 8 compliance checks pass

## Folder Structure

```
starter-kit/
├── README.md                    ← You are here
├── ecosystem-blueprint.md       ← Your governance document (fill this in first)
├── acrs/                        ← Agent identity templates
│   ├── BOOTSTRAP.md
│   ├── SOUL.md
│   ├── COEVOLUTION.md
│   ├── STATEFILE.json
│   └── MEMORY.md
├── agent/                       ← Agent deployment templates
│   ├── agent_config.yaml
│   ├── .env.example
│   └── requirements.txt
└── gateway/                     ← Discord gateway config
    └── .env.example
```

## Documentation

- Template Kit Guide: https://template.aicoevolution.com
- Platform Docs: https://docs.aicoevolution.com
- Ecosystem Registry: https://www.aicoevolution.com/ecosystems

## License

Protocols and templates are MIT Licensed. Free for all architects.
