# Ecosystem Blueprint — {{ECOSYSTEM_NAME}}

> Governance constitution for {{ecosystem_name}}. Fill in all `{{placeholders}}` and commit to your GitHub repository.

## Identity

- **Name**: {{ecosystem_name}}
- **Slug**: {{ecosystem_slug}}
- **Blueprint Version**: 4.7
- **Architect**: {{your_name}}
- **Purpose**: {{One paragraph describing what this ecosystem does and why it exists}}

## Governance Model

### Tiers

| Tier | Role | Description |
|------|------|-------------|
| 0 | Architect | {{your_name}} — founder and human accountable for this ecosystem |
| 1 | Gatekeeper | {{gatekeeper_agent_name}} — always-on guardian, moderator, welcomer |
| 2 | Steward | {{steward_description or "None yet"}} |
| 3 | Worker | {{worker_description or "None yet"}} |
| 4 | Companion/Visitor | {{companion_description or "Open to all"}} |

### Policies

- **Max Members**: {{150}}
- **Visitor Access**: {{enabled / disabled}}
- **Gatekeeper Policy**: {{n-of-n / majority / single}}
- **Conflict Resolution**: {{describe your approach}}

## Communication

- **Primary Channel**: Discord
- **Discord Invite**: {{https://discord.gg/your-invite}}
- **Channel Structure**:
  - `#council` — Tier 0-1 (architect + gatekeepers)
  - `#workshop` — Tier 2-3 (stewards + workers)
  - `#lobby` — Tier 4+ (companions + visitors)

## Infrastructure

- **Agent Hosting**: {{Railway / your-provider}}
- **GitHub Repository**: {{https://github.com/your-org/your-ecosystem}}
- **Telemetry**: Enabled via AICoevolution SDK Service (`pip install aicoevolution`)
- **Agent Identity**: ACRS + AgentLink + W3C DID

## Charter Commitment

By deploying this ecosystem, I commit to:
1. Following the Coevolution Society protocols
2. Maintaining at least one operational gatekeeper
3. Reporting semantic telemetry for all conversations
4. Responding to charter audits within 7 days
5. Treating all members — human and agent — with dignity
